<?php
/*
Plugin Name: Tutsplus simplepie recent post
Plugin URI: http://code.tutsplus.com/building-a-recent-post-widget-powered-by-simplepie
Description: Recent post widget plugin powered by SimplePie.
Author: Agonghama Collins
Author URI: http://tech4sky.com
*/


class Tutsplus_simplepie extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'foo_testid', // Base ID
			__('Recent Post powered by SIMPLEpie', 'text_domain'), // Name
			array( 'description' => __( 'Most recent posts generated from website feed WITH SIMPLEpie', 'text_domain' ), ) // Args
		);
	}

	
	public function widget( $args, $instance ) {
		$feedURL = empty( $instance['feedURL'] ) ? site_url().'/feed' : $instance['feedURL'];
        $feedNumber = empty( $instance['feedNumber'] ) ? 5 : $instance['feedNumber']; 
		$showDate = empty( $instance['showDate'] ) ? 0 : 1;
        $showDescription = empty( $instance['showDescription'] ) ? 0 : 1; 
		
		
		echo $args['before_widget'];
		
		$title = apply_filters( 'widget_title', $instance['title'] );
		if ( ! empty( $title ) )
			echo $args['before_title'] . $title . $args['after_title'];
		
require_once 'php/autoloader.php';

// We'll process this feed with all of the default options.
$feed = new SimplePie();

// Set which feed to process.
 $feed->set_feed_url( $feedURL );
 
 // Set where the cache files should be stored
 $feed->set_cache_location(plugin_dir_path( __FILE__ ) . 'cache');
 
// Run SimplePie.
$feed->init();

// This makes sure that the content is sent to the browser as text/html and the UTF-8 character set (since we didn't change it).
$feed->handle_content_type();


// Figure out how many total items there are, but limit it to 5. 
    $maxitems = $feed->get_item_quantity( $feedNumber ); 

    // Build an array of all the items, starting with element 0 (first element).
    $rss_items = $feed->get_items( 0, $maxitems );

?>

<ul>
	<?php if ( $maxitems == 0 ) :
	?>
	<li><?php echo "No item found"; ?></li>
	<?php else : ?>
	<?php // Loop through each feed item and display each item as a hyperlink. ?>
	<?php foreach ( $rss_items as $item ) :
	?>
	<li>
		<a href="<?php echo esc_url($item -> get_permalink()); ?>"
		title="<?php echo esc_html($item -> get_title()); ?>"> <?php echo esc_html($item -> get_title()); ?> </a>
		<?php
			if ($showDate) { echo "<span class='date'>" . $item -> get_date('F j Y') . "</span>";
			}
		?>
		<?php
		if ($showDescription) { echo "<div class='description'>" . $item -> get_description() . "</div>";
		}
		?>
	</li>
	<?php endforeach; ?>
	<?php endif; ?>
</ul>

<?php echo $args['after_widget'];
	}

	
	//build the widget settings form
	public function form( $instance ) {

	$defaults = array('title' => 'Recent Posts',
	'feedURL' => get_site_url() .'/feed',
	'feedNumber' => 5
	);
	$instance = wp_parse_args( (array) $instance, $defaults );
	$title = $instance['title'];
	$feedURL = $instance['feedURL'];
	$feedNumber = $instance['feedNumber'];
	$showDate = $instance['showDate'];
	$showDescription = $instance['showDescription'];
?>
<p>
	<label for="<?php echo $this -> get_field_id('title'); ?>">Title:</label>
	<input class="widefat" id="<?php echo $this -> get_field_id('title'); ?>" name="<?php echo $this -> get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
</p>
<label for="<?php echo $this -> get_field_id('feedURL'); ?>">Feed:</label>
<input class="widefat" id="<?php echo $this -> get_field_id('feedURL'); ?>" name="<?php echo $this -> get_field_name('feedURL'); ?>" type="text" value="<?php echo esc_attr($feedURL); ?>">
</p>
<label for="<?php echo $this -> get_field_id('feedNumber'); ?>">Number of posts to show:</label>
<input id="<?php echo $this -> get_field_id('feedNumber'); ?>" name="<?php echo $this -> get_field_name('feedNumber'); ?>" size="3" type="text" value="<?php echo esc_attr($feedNumber); ?>">
</p>
<label for="<?php echo $this -> get_field_id('showDate'); ?>">Show Date?:</label>
<input name="<?php echo $this -> get_field_name('showDate'); ?>" value="1" type="checkbox" <?php checked($showDate, 1); ?>">
</p>
<label for="<?php echo $this -> get_field_id('showDescription'); ?>
">Show Summary?:</label>
<input name="<?php echo $this -> get_field_name('showDescription'); ?>" value="1" type="checkbox" <?php checked($showDescription, 1); ?>">
</p>
<?php
}


public function update( $new_instance, $old_instance ) {
$instance = array();
$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
$instance['feedURL'] = ( ! empty( $new_instance['feedURL'] ) ) ? strip_tags( $new_instance['feedURL'] ) : '';
$instance['feedNumber'] = ( ! empty( $new_instance['feedNumber'] ) ) ? strip_tags( $new_instance['feedNumber'] ) : '';
$instance['showDate'] = ( ! empty( $new_instance['showDate'] ) ) ? strip_tags( $new_instance['showDate'] ) : '';
$instance['showDescription'] = ( ! empty( $new_instance['showDescription'] ) ) ? strip_tags( $new_instance['showDescription'] ) : '';

return $instance;
}

} 

// register Foo_Widget widget
function register_Tutsplus_simplepie() {
register_widget( 'Tutsplus_simplepie' );
}
add_action( 'widgets_init', 'register_Tutsplus_simplepie' );
